//Windows 10
//5.5.2
//To Calculate the performance parameters for a Long transmission line using ABCD parameters.
//Given r=0.2 per km,L=1.3mH per km, C=0.01microfarad,power factor =0.8, length of line =120 km, recivening end power=40MW,receiving end voltage =132kV.Calculate efficiency of using ABCD parameters calcuation.
clear;
clc;
R=0.2;
L=1.3e-3;
C=0.001e-6;
z=R+%i*L*314;
y=%i*314*C;
cimp=(z/y);
Zc=sqrt(cimp);
adm=y*z;
Y=sqrt(adm);
lg=120;
Vr=(132)/sqrt(3);
Ir=(40*1000)/(sqrt(3)*132*0.8);
cosine=cosh(Y*lg);
sine=sinh(Y*lg);
a=cosine;
b=Zc*sine;
c=((1/Zc)*sine);
d=a;
disp(d,c,b,a,'The values of ABCD parameters respectively are');
irv=Ir*(0.8-%i*0.6);
irvinKA=irv*10^-3;
vs=((a*Vr)+(b*irvinKA ));
disp(vs,'the value of sending end voltage is');
vsh=abs(vs);
is=c*Vr*1000+d*irv;
disp(is,'the value of sending end current is');
pis=polar(is);
reg=(((vsh/a)-abs(Vr))/Vr)*100;
mreg=abs(reg);
disp(mreg,'Regulation of the line is');
spl=3*vsh*is;
splab=abs(spl);
eff=(40*1000/splab)*100;
disp(eff,'efficiency of the line is');
